precision highp float;
varying vec2 vTextureCoord;
uniform sampler2D sTexture;
uniform float minHue;
uniform float maxHue;
// functions

float changecolor(float color)
	{
		float resturnColor;
		if(color>0.0404500)
			{
        		resturnColor =pow((color+0.055000/1.055000),2.400000);
        	}
        else
        	{
        resturnColor=color/12.920000;
        	}
        return resturnColor;
        }
float changeXYZElement(float e)
	{
    	if(e > 0.008856)
        	{
        		e = pow( e,( 1.000000/3.000000 ));
        	}
       	else
        	{
        		e = ( 7.787000 * e ) + ( 16.000000 / 116.000000 );
        	}
        return e;
	}
vec3 XYZtoLCH(float X,float Y,float Z)
	{
    	float ref_X =  95.047000;
        float ref_Y = 100.000000;
        float ref_Z = 108.883000;
        X/=ref_X;
        Y/=ref_Y;
        Z/=ref_Z;
        X = changeXYZElement(X);
        Y = changeXYZElement(Y);
        Z = changeXYZElement(Z);
        float CIE_L = ( 116.000000 * Y ) - 16.000000;
        float CIE_A = 500.000000 * ( X - Y );
        float CIE_B = 200.000000 * ( Y - Z );
        float H = atan( CIE_B,CIE_A );
        if(H > 0.000000)
        	{
        		H = degrees(H);
        	}
        else
        	{
        		H=360.000000 - degrees(abs(H));
        	}
        float C = sqrt(pow(CIE_A,2.000000)+pow(CIE_B,2.000000));
        //CIE-C* = sqrt( CIE-a* ^ 2 + CIE-b* ^ 2 )
        vec3 LCH = vec3(CIE_L,C,H);
        //return H;
        return LCH;
	}
vec3 RGBtoLCH(float red,float green,float blue) 
	{
    	red=changecolor(red);
        green=changecolor(green);
        blue=changecolor(blue);
        red*=100.000000;
        green*=100.000000;
        blue*=100.000000;
        float X = red * 0.412400 + green * 0.357600 + blue * 0.180500;
        float Y = red * 0.212600 + green * 0.715200 + blue * 0.072200;
        float Z = red * 0.019300 + green * 0.119200 + blue * 0.950500;
        vec3 LCH = XYZtoLCH(X,Y,Z);
        return LCH;
	}

void main() {
		vec4 color = texture2D(sTexture, vTextureCoord);
		vec3 LCH = RGBtoLCH(color.r,color.g,color.b);
		if(minHue>maxHue)
		{
			if(!(LCH.z>=minHue || LCH.z<=maxHue))
			{
				float sum = (color.r+color.g+color.b)/3.000000;
				color = vec4(sum,sum,sum,color.a);
			}
		}
		else
		{
			if(!(LCH.z>=minHue && LCH.z<=maxHue))
			{
				float sum = (color.r+color.g+color.b)/3.000000;
				color = vec4(sum,sum,sum,color.a);
			}
		}
        gl_FragColor = color;
}