precision highp float;
varying vec2 vTextureCoord;
uniform sampler2D sTexture;

uniform float scaleFactor;
uniform float textureSize;
uniform float textureWidth;
uniform float textureHeight;


uniform float fade;
uniform float lines;
uniform float brightness;


float getGray(float x,float y){
    if(x<0.0){
        x = 0.0;
    }else if(x>=textureWidth){
        x = textureWidth - 1.0;
    }
    
    if(y<0.0){
        y = 0.0;
    }else if(y>=textureHeight){
        y = textureHeight - 1.0;
    }
    
    x/=textureSize;
    y/=textureSize;
    vec4 vTempColor = texture2D(sTexture, vec2(x,y));
    
    float r = vTempColor.r*255.0;
	float g = vTempColor.g*255.0;
	float b = vTempColor.b*255.0;

	float gray = (r+g+b)/3.0;
    return gray;
}

float saturate_cast(float v){
    if(v<0.0){
        v = 0.0;
    }else{
        if(v>255.0){
            v = 255.0;
        }
    }
    return v;
}

vec3 RGBtoYUV(vec3 rgb){
	vec3 yuv = vec3(0.0,0.0,0.0);
	
	float red = rgb.r*255.0;
	float green = rgb.g*255.0;
	float blue = rgb.b*255.0;
	
	float y = 0.299*red + 0.587*green + 0.114*blue;
	float u = (blue-y)*0.565;
	float v = (red-y)*0.713;
	yuv.r = y;
	yuv.g = u;
	yuv.b = v;
	
	return yuv;
}

vec3 YUVtoRGB(vec3 yuv){
	vec3 rgb = vec3(0.0,0.0,0.0);
	rgb.r = yuv.x + 1.403*yuv.z;
	rgb.g = yuv.x - 0.344*yuv.y - 0.714*yuv.z;
	rgb.b = yuv.x + 1.770*yuv.y;
	rgb.r/=255.0;
	rgb.g/=255.0;
	rgb.b/=255.0;
	
	return rgb;
}

float setupLuma(float y,float howmuch){
	y = y/ howmuch;
	y += 0.5;
	y = floor(y);
    y *= howmuch;
	return y;
}

void main() {
	vec4 vColor = texture2D(sTexture, vTextureCoord);
	
	if(textureSize>0.0 ){
	
		//lines
		float satLines = lines;
		if(satLines<1.0){
			satLines = 1.0;
		}else if(satLines>99.0){
			satLines = 99.0;
		}
	
		float lk = 100.0 / (100.0 - satLines);
		float lb = 255.0 * satLines / (satLines - 100.0);
		
		//brightness
		float bb = 0.0;
    	float bk = 0.0;
    	if (brightness >= 50.0) {
       		bb = 128.0 * (brightness - 50.0) / 50.0;
        	bk = (255.0 - bb) / 255.0;
    	}
    	else {
        	bk = (255.0 + 128.0 * (brightness - 50.0) / 50.0) / 255.0;
    	}
		
	
		float fXIndex = vTextureCoord.x*textureSize;
    	float fYIndex = vTextureCoord.y*textureSize;
    	
    	vec3 yuv = RGBtoYUV(vColor.rgb);
    	
    	yuv.x = bk * yuv.x + bb;
    	
    	float y = setupLuma(yuv.x,48.0);
    	
    	yuv.x = y;
    	vec3 rgb = YUVtoRGB(yuv);
    	

    	float tl = getGray(fXIndex-scaleFactor,fYIndex-scaleFactor);
    	float l =   getGray(fXIndex-scaleFactor,fYIndex);
    	float bl =  getGray(fXIndex-scaleFactor,fYIndex+scaleFactor);
    	float t =   getGray(fXIndex,fYIndex-scaleFactor);
    	float b =  getGray(fXIndex,fYIndex+scaleFactor);
    	float tr =  getGray(fXIndex+scaleFactor,fYIndex-scaleFactor);
    	float r =   getGray(fXIndex+scaleFactor,fYIndex);
    	float br =  getGray(fXIndex+scaleFactor,fYIndex+scaleFactor);
   
    	float dX = -tl - 2.0*l - bl + tr + 2.0*r + br;
    	float dY = -tl - 2.0*t - tr + bl + 2.0*b + br;
    	float grad = sqrt(abs(dX*dX) + abs(dY*dY));
    	if(grad<0.0){
			grad = 0.0;
    	}else if(grad>255.0){
			grad = 255.0;
		}
    	grad =255.0 - grad/5.66;
    
    	
    	
    	float sobel = lk*grad+lb;
    	
    	sobel/=255.0;
    	
    	
    	
    	
    	rgb.r*=sobel;
    	rgb.g*=sobel;
    	rgb.b*=sobel;
    	
    	vec4 effectColor = vec4(rgb,vColor.a);
    	vec4 destColor = (fade*vColor+(100.0-fade)*effectColor)/100.0;
    	
    	if(destColor.r<0.0){
    		destColor.r = 0.0;
    	}else if(destColor.r>1.0){
    		destColor.r = 1.0;
    	}
    	
    	if(destColor.g<0.0){
    		destColor.g = 0.0;
    	}else if(destColor.g>1.0){
    		destColor.g = 1.0;
    	}
    	
    	if(destColor.b<0.0){
    		destColor.b = 0.0;
    	}else if(destColor.b>1.0){
    		destColor.b = 1.0;
    	}
    	
    	gl_FragColor = destColor;
    	
	}else{
		gl_FragColor = vColor;
	}    
}
