precision highp float;
varying vec2 vTextureCoord;
uniform sampler2D sTexture;

uniform float scaleFactor;
uniform float textureSize;
uniform float textureWidth;
uniform float textureHeight;

uniform float fade;
uniform float contrast;
uniform float brightness;
uniform float lines;



float getGray(float x,float y){
    if(x<0.0){
        x = 0.0;
    }else if(x>=textureWidth){
        x = textureWidth - 1.0;
    }
    
    if(y<0.0){
        y = 0.0;
    }else if(y>=textureHeight){
        y = textureHeight - 1.0;
    }
    
    x/=textureSize;
    y/=textureSize;
    vec4 vTempColor = texture2D(sTexture, vec2(x,y));
    
    float r = vTempColor.r*255.0;
	float g = vTempColor.g*255.0;
	float b = vTempColor.b*255.0;

	float gray = (r+g+b)/3.0;
    return gray;
}


float saturate_cast(float v){
    if(v<0.0){
        v = 0.0;
    }else{
        if(v>255.0){
            v = 255.0;
        }
    }
    return v;
}


vec4 initLastParams(vec4 srcColor,vec4 effectColor){
     effectColor.r-=0.5;
     effectColor.g-=0.5;
     effectColor.b-=0.5;
     effectColor *= (contrast/50.0);
     effectColor.r+=0.5;
     effectColor.g+=0.5;
     effectColor.b+=0.5;
     effectColor *= (brightness/50.0);
     
     effectColor.r = saturate_cast(effectColor.r);
     effectColor.g = saturate_cast(effectColor.g);
     effectColor.b = saturate_cast(effectColor.b);
     
     vec4 destColor = (fade*srcColor+(100.0-fade)*effectColor)/100.0;
     return destColor;
}

void main() {
	vec4 vColor = texture2D(sTexture, vTextureCoord);

	if(textureSize>0.0){
		float fXIndex = vTextureCoord.x*textureSize;
    	float fYIndex = vTextureCoord.y*textureSize;

    	float tl = getGray(fXIndex-scaleFactor,fYIndex-scaleFactor);
    	float l =   getGray(fXIndex-scaleFactor,fYIndex);
    	float bl =  getGray(fXIndex-scaleFactor,fYIndex+scaleFactor);
    	float t =   getGray(fXIndex,fYIndex-scaleFactor);
    	float b =  getGray(fXIndex,fYIndex+scaleFactor);
    	float tr =  getGray(fXIndex+scaleFactor,fYIndex-scaleFactor);
    	float r =   getGray(fXIndex+scaleFactor,fYIndex);
    	float br =  getGray(fXIndex+scaleFactor,fYIndex+scaleFactor);
   
    	float dX = -tl - 2.0*l - bl + tr + 2.0*r + br;
    	float dY = -tl - 2.0*t - tr + bl + 2.0*b + br;
    	float grad = abs(dX) + abs(dY);
    	
    	
    	grad *= lines/500.0;
    	
    	grad = saturate_cast(grad);
    	if(grad>7.0){
    		grad = 128.0;
    	}else{
    		grad = 255.0 - grad;
    	}
    	
    	
    
    	grad/=255.0;
    
    	float red = grad;
		float green = grad;
		float blue = grad;
    	if(red<0.0){
        	red = 0.0;
    	}else if(red>1.0){
        	red = 1.0;
    	}
    	if(green<0.0){
        	green = 0.0;
    	}else if(green>1.0){
        	green = 1.0;
    	}
    	if(blue<0.0){
        	blue = 0.0;
    	}else if(blue>1.0){
        	blue = 1.0;
    	}
    	vec4 effectColor = vec4(red,green,blue,vColor.a);
    	gl_FragColor = initLastParams(vColor,effectColor);
	}else{
		gl_FragColor = vColor;
	}   
}