precision highp float;
varying vec2 vTextureCoord;
uniform sampler2D sTexture;
uniform float scaleFactor;
uniform float textureSize;
uniform float textureWidth;
uniform float textureHeight;
void main() {
	
    vec4 vColor = texture2D(sTexture, vTextureCoord);
    
    float fXIndex = vTextureCoord.x*textureSize;
    float fYIndex = vTextureCoord.y*textureSize;
    /*
    guassian
    mat3 convolutionMatrix = mat3( 0.045, 0.122, 0.045,
      0.122, 0.332, 0.122,
      0.045, 0.122, 0.045);*/
                    /*
                    gaussianBlur: [
      0.045, 0.122, 0.045,
      0.122, 0.332, 0.122,
      0.045, 0.122, 0.045
    ]
                    
                    */
                    
    
    
    /*mat3 convolutionMatrix = mat3(  -1.0, -1.0, -1.0,
      -1.0,  9.0, -1.0,
      -1.0, -1.0, -1.0);
    
    
    unsharpen
    -1, -1, -1,
      -1,  9, -1,
      -1, -1, -1
    */
    
    mat3 convolutionMatrix = mat3( -2.0, -1.0,  0.0,
       -1.0,  1.0,  1.0,
        0.0,  1.0,  2.0);
    
    /*
    emboss: [
       -2, -1,  0,
       -1,  1,  1,
        0,  1,  2
    ]
    
    */
    
    if( ! ( fYIndex < scaleFactor || fYIndex > textureHeight - scaleFactor || 
            fXIndex < scaleFactor || fXIndex > textureWidth - scaleFactor ))
    {
    	float redXSum = vColor.r*convolutionMatrix[1][1];
    	//float redYSum = 0.0;
    
    	float greenXSum = vColor.g*convolutionMatrix[1][1];
    	//float greenYSum = 0.0;
    
    	float blueXSum = vColor.b*convolutionMatrix[1][1];
    	//float blueYSum = 0.0;
    	
    	float fTempX = ( fXIndex  -scaleFactor + 0.5 ) / textureSize ;
        float fTempY = ( fYIndex  -scaleFactor + 0.5 ) / textureSize ;
        vec4 vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
        
        // X Direction
        redXSum = redXSum + convolutionMatrix[0][0]*vTempColor.r;
        greenXSum = greenXSum + convolutionMatrix[0][0]*vTempColor.g;
        blueXSum = blueXSum +  convolutionMatrix[0][0]*vTempColor.b;
        
        fTempX = ( fXIndex +scaleFactor + 0.5 ) / textureSize ;
        fTempY = ( fYIndex  -scaleFactor + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
        
        // X Direction
        redXSum = redXSum + convolutionMatrix[0][2]*vTempColor.r;
        greenXSum = greenXSum + convolutionMatrix[0][2]*vTempColor.g;
        blueXSum = blueXSum + convolutionMatrix[0][2]*vTempColor.b;
        
        fTempX = ( fXIndex -scaleFactor + 0.5 ) / textureSize ;
        fTempY = ( fYIndex  + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
        
        // X Direction
        redXSum = redXSum+convolutionMatrix[1][0]*vTempColor.r;
        greenXSum = greenXSum+convolutionMatrix[1][0]*vTempColor.g;
        blueXSum = blueXSum+convolutionMatrix[1][0]*vTempColor.b;
        
        fTempX = ( fXIndex +scaleFactor + 0.5 ) / textureSize ;
        fTempY = ( fYIndex  + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
        
        // X Direction
        redXSum = redXSum+convolutionMatrix[1][2]*vTempColor.r;
        greenXSum = greenXSum+convolutionMatrix[1][2]*vTempColor.g;
        blueXSum = blueXSum+convolutionMatrix[1][2]*vTempColor.b;
        
        fTempX = ( fXIndex -scaleFactor + 0.5 ) / textureSize ;
        fTempY = ( fYIndex +scaleFactor + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
        
        // X Direction
        redXSum = redXSum +convolutionMatrix[2][0]*vTempColor.r;
        greenXSum = greenXSum +convolutionMatrix[2][0]*vTempColor.g;
        blueXSum = blueXSum + +convolutionMatrix[2][0]*vTempColor.b;
        
        fTempX = ( fXIndex +scaleFactor + 0.5 ) / textureSize ;
        fTempY = ( fYIndex +scaleFactor + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
        
         // X Direction
        redXSum = redXSum +convolutionMatrix[2][2]*vTempColor.r;
        greenXSum = greenXSum +convolutionMatrix[2][2]*vTempColor.g;
        blueXSum = blueXSum +convolutionMatrix[2][2]*vTempColor.b;
        
        
        fTempX = ( fXIndex  + 0.5 ) / textureSize ;
        fTempY = ( fYIndex -scaleFactor + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
        
        // X Direction
        redXSum = redXSum + convolutionMatrix[0][1]*vTempColor.r;
        greenXSum = greenXSum + convolutionMatrix[0][1]*vTempColor.g;
        blueXSum = blueXSum + convolutionMatrix[0][1]*vTempColor.b;
        
        fTempX = ( fXIndex  + 0.5 ) / textureSize ;
        fTempY = ( fYIndex +scaleFactor + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
        
        // X Direction
        
        redXSum = redXSum + convolutionMatrix[2][1]*vTempColor.r;
        greenXSum = greenXSum + convolutionMatrix[2][1]*vTempColor.g;
        blueXSum = blueXSum + convolutionMatrix[2][1]*vTempColor.b;
        
        
        
        float oneFloat = float(1.0);
        float zeroFloat = float(0.0);
        
        if(redXSum<zeroFloat){
        	redXSum = zeroFloat;
        }
        
        if(redXSum>oneFloat){
        	redXSum = oneFloat;
        }
        
        if(greenXSum<zeroFloat){
        	greenXSum = zeroFloat;
        }
        
        if(greenXSum>oneFloat){
        	greenXSum = oneFloat;
        }
        
        
        if(blueXSum<zeroFloat){
        	blueXSum = zeroFloat;
        }
        
        if(blueXSum>oneFloat){
        	blueXSum = oneFloat;
        }
        /*
        redXSum = 1.0 - redXSum;
        greenXSum = 1.0-greenXSum;
        blueXSum = 1.0-blueXSum;
        
        float sum = (redXSum+greenXSum+blueXSum)/3.0;*/
        
        vColor.r = redXSum;
        vColor.g = greenXSum;
        vColor.b = blueXSum;
        //vColor = vec4((1.0-fRedTotalSum),(1.0-fGreenTotalSum),(1.0-fBlueTotalSum),vColor.a);
    }
    else
    {
    	vColor.r=1.0;
    	vColor.g = 1.0;
    	vColor.b = 1.0;
    }
    
    gl_FragColor = vColor;
}