precision highp float;
varying vec2 vTextureCoord;
uniform sampler2D sTexture;

uniform float scaleFactor;
uniform float textureSize;
uniform float textureWidth;
uniform float textureHeight;

uniform float fade;
uniform int blendMode;
uniform int invertYCoord;

uniform sampler2D sTexture2;
uniform float texture2Size;
uniform float texture2Width;
uniform float texture2Height;

float screenValuesBlend(float srcValue,float destValue){
    srcValue *= 255.0;
    destValue *= 255.0; 
    float resultValue = (255.0 - (((255.0 - srcValue)*(255.0-destValue))/255.0));
    return resultValue/255.0;
}

vec4 screenBlend(vec4 originColor,vec4 maskColor){
	vec4 result;
	result.r = screenValuesBlend(originColor.r,maskColor.r);
	result.g = screenValuesBlend(originColor.g,maskColor.g);
	result.b = screenValuesBlend(originColor.b,maskColor.b);
	result.a = originColor.a;
	return result;
}

float overlayValuesBlend(float srcValue,float destValue){
    srcValue *= 255.0;
    destValue *= 255.0;
    
    float resultValue;
    
    if(srcValue>127.5)
	{
		float unitValue = (255.0-srcValue)/127.5;
		float minValue = srcValue - (255.0-srcValue);
		resultValue =  ((destValue * unitValue) + minValue);
	}
	else
	{
		float unitValue =srcValue/127.5;
		resultValue =  (destValue * unitValue);
	}
    return resultValue/255.0;
}

vec4 overlayBlend(vec4 originColor,vec4 maskColor){
	vec4 result;
	result.r = overlayValuesBlend(originColor.r,maskColor.r);
	result.g = overlayValuesBlend(originColor.g,maskColor.g);
	result.b = overlayValuesBlend(originColor.b,maskColor.b);
	result.a = originColor.a;
	return result;
}

float multiplyValuesBlend(float srcValue,float destValue){
    float result = srcValue*destValue;
    if(result<0.0){
        result = 0.0;
    }else if(result>1.0){
        result = 1.0;
    }
    return result;
}

vec4 multiplyBlend(vec4 originColor,vec4 maskColor){
	vec4 result;
	result.r = multiplyValuesBlend(originColor.r,maskColor.r);
	result.g = multiplyValuesBlend(originColor.g,maskColor.g);
	result.b = multiplyValuesBlend(originColor.b,maskColor.b);
	result.a = originColor.a;
	return result;
}

float differenceValuesBlend(float srcValue,float destValue){
    float result = abs(srcValue - destValue);
    if(result<0.0){
        result = 0.0;
    }else if(result>1.0){
        result = 1.0;
    }
    return result;
}

vec4 differenceBlend(vec4 originColor,vec4 maskColor){
	vec4 result;
	result.r = differenceValuesBlend(originColor.r,maskColor.r);
	result.g = differenceValuesBlend(originColor.g,maskColor.g);
	result.b = differenceValuesBlend(originColor.b,maskColor.b);
	result.a = originColor.a;
	return result;
}

void main() {
	vec4 vColor = texture2D(sTexture, vTextureCoord);
	vec4 destColor = vColor;
	if(textureSize > 0.0 ){
	
		float fXIndex = vTextureCoord.x*textureSize;
    	float fYIndex = vTextureCoord.y*textureSize;
    	if(texture2Size > 0.0){
    		
    		float scale1 = texture2Width/textureWidth;
    		float scale2 =  texture2Height/textureHeight;
    		
    		float scale = scale2;
    		if(scale1 < scale2){
    			scale = scale1;
    		}
    		
    		float scaledWidth = scale*textureWidth;
			float scaledHeight = scale*textureHeight;
			
			float resizeScaleX = scaledWidth/texture2Width;
			float resizeScaleY = scaledHeight/texture2Height;
			
			float resizeWidth = texture2Width*resizeScaleX;
			float resizeHeight = texture2Height*resizeScaleY;
			
			float offsetX = (texture2Width - resizeWidth)/2.0;
			float offsetY = (texture2Height - resizeHeight)/2.0;
			
			float x = fXIndex;
    		if(invertYCoord == 1){
    			x = textureWidth - fXIndex;
    		}
    	
    		float xInBlendTexture =  x/textureWidth*(offsetX + resizeWidth)/texture2Size;
 			float yInBlendTexture =  fYIndex/textureHeight*(offsetY + resizeHeight)/texture2Size;
 			vec4 maskColor = texture2D(sTexture2, vec2(xInBlendTexture,yInBlendTexture));
 			
 			if(blendMode == 0){
 				//alpha
 				destColor.r = (vColor.r + maskColor.r)/2.0;
    			destColor.g = (vColor.g + maskColor.g)/2.0;
    			destColor.b = (vColor.b + maskColor.b)/2.0;
 			}else if(blendMode == 1){
 				destColor = screenBlend(vColor,maskColor);
 			}else if(blendMode == 2){
 				destColor = overlayBlend(vColor,maskColor);
 			}else if(blendMode == 3){
 				destColor = differenceBlend(vColor,maskColor);
 			}else if(blendMode == 4){
 				destColor = multiplyBlend(vColor,maskColor);
 			}
 			if(fade >0.0){
 				float red = (fade*vColor.r+(100.0-fade)*destColor.r)/100.0;
				float green = (fade*vColor.g+(100.0-fade)*destColor.g)/100.0;
				float blue = (fade*vColor.b+(100.0-fade)*destColor.b)/100.0;
				destColor.r = red;
				destColor.g = green;
				destColor.b = blue;
 			}
 			

    	}
	}
	
	gl_FragColor = destColor;
}