precision highp float;
varying vec2 vTextureCoord;
uniform sampler2D sTexture;

uniform float scaleFactor;
uniform float textureSize;
uniform float textureWidth;
uniform float textureHeight;

uniform sampler2D sTexture2;
uniform float texture2Size;
uniform float texture2Width;
uniform float texture2Height;

uniform float fade;
uniform float contrast;
uniform float brightness;
uniform float lines;



float getGray(float x,float y){
    if(x<0.0){
        x = 0.0;
    }else if(x>=textureWidth){
        x = textureWidth - 1.0;
    }
    
    if(y<0.0){
        y = 0.0;
    }else if(y>=textureHeight){
        y = textureHeight - 1.0;
    }
    
    x/=textureSize;
    y/=textureSize;
    vec4 vTempColor = texture2D(sTexture, vec2(x,y));
    
    float r = vTempColor.r*255.0;
	float g = vTempColor.g*255.0;
	float b = vTempColor.b*255.0;

	float gray = (r+g+b)/3.0;
    return gray;
}


float saturate_cast(float v){
    if(v<0.0){
        v = 0.0;
    }else{
        if(v>255.0){
            v = 255.0;
        }
    }
    return v;
}

vec3 RGBtoYUV(vec3 rgb){
	vec3 yuv = vec3(0.0,0.0,0.0);
	
	float red = rgb.r*255.0;
	float green = rgb.g*255.0;
	float blue = rgb.b*255.0;
	
	float y = 0.299*red + 0.587*green + 0.114*blue;
	float u = (blue-y)*0.565;
	float v = (red-y)*0.713;
	yuv.r = y;
	yuv.g = u;
	yuv.b = v;
	
	
	return yuv;
}

vec3 YUVtoRGB(vec3 yuv){
	vec3 rgb = vec3(0.0,0.0,0.0);
	rgb.r = yuv.x + 1.403*yuv.z;
	rgb.g = yuv.x - 0.344*yuv.y - 0.714*yuv.z;
	rgb.b = yuv.x + 1.770*yuv.y;
	rgb.r/=255.0;
	rgb.g/=255.0;
	rgb.b/=255.0;
	
	
	return rgb;
}

float getTextureRGB(float gray,float x,float y,float defaultValue){
    float value = defaultValue;
    float halfsize = texture2Width/2.0;
	float textX = x/textureWidth*halfsize;
	float textY =  y/textureHeight*halfsize;
    
    bool getPixel = true;
    
    
    if ( gray < 26.0 )
	    {
			textX += halfsize;
			textY += halfsize;
	    }else
	    if ( (gray >= 77.0  ) && (gray < 128.0) )
	    {
	    	textY += halfsize;
	    }else
	    if ( (gray >= 128.0 ) && (gray < 179.0) )
	    {
	    	textX += halfsize;
	    }else
	    if( gray > 255.0 ) 
	    {
	    	getPixel = false;
	    }
        
    if(getPixel){
		if(textX>=texture2Width){
			textX = texture2Width-1.0;
		}
		if(textY>=texture2Height){
			textY = texture2Height-1.0;
		}
        vec4 color = texture2D(sTexture2, vec2(textX/texture2Size,textY/texture2Size));
        value = (color.r+color.g+color.b)/3.0;
	}
    
    return value;
}

float setupLuma(float y,float howmuch){
	y = y/ howmuch;
	y -= 0.5;
	y = ceil(y);
    y *= howmuch;
    saturate_cast(y);
	return y;
	//saturate_cast<unsigned char>(ceil((i / 64.0) - 0.5) * 64);
}


vec4 initLastParams(vec4 srcColor,vec4 effectColor){
     effectColor.r-=0.5;
     effectColor.g-=0.5;
     effectColor.b-=0.5;
     effectColor *= (contrast/50.0);
     effectColor.r+=0.5;
     effectColor.g+=0.5;
     effectColor.b+=0.5;
     effectColor *= (brightness/50.0);
     
     effectColor.r = saturate_cast(effectColor.r);
     effectColor.g = saturate_cast(effectColor.g);
     effectColor.b = saturate_cast(effectColor.b);
     
     vec4 destColor = (fade*srcColor+(100.0-fade)*effectColor)/100.0;
     return destColor;
}

void main() {
	vec4 vColor = texture2D(sTexture, vTextureCoord);

	if(textureSize>0.0 && texture2Size>0.0 && texture2Width>0.0 && texture2Height>0.0){
		float fXIndex = vTextureCoord.x*textureSize;
    	float fYIndex = vTextureCoord.y*textureSize;

    	float tl = getGray(fXIndex-scaleFactor,fYIndex-scaleFactor);
    	float l =   getGray(fXIndex-scaleFactor,fYIndex);
    	float bl =  getGray(fXIndex-scaleFactor,fYIndex+scaleFactor);
    	float t =   getGray(fXIndex,fYIndex-scaleFactor);
    	float b =  getGray(fXIndex,fYIndex+scaleFactor);
    	float tr =  getGray(fXIndex+scaleFactor,fYIndex-scaleFactor);
    	float r =   getGray(fXIndex+scaleFactor,fYIndex);
    	float br =  getGray(fXIndex+scaleFactor,fYIndex+scaleFactor);
   
    	float dX = -tl - 2.0*l - bl + tr + 2.0*r + br;
    	float dY = -tl - 2.0*t - tr + bl + 2.0*b + br;
    	float grad = abs(dX) + abs(dY);
    	
    	//edge = 255 - saturate_cast<unsigned char>((abs(h_grad) + abs(v_grad)) * l / 50);
    	grad *= lines/50.0;
    	grad = saturate_cast(grad);
    	grad = 255.0-grad;
    	grad/=255.0;
    	
    	vec3 yuv = RGBtoYUV(vColor.rgb);
    	yuv.x = setupLuma(yuv.x,64.0);
    	vec3 rgb = YUVtoRGB(yuv);
    	
    	float gray = (vColor.r+vColor.g+vColor.b)/3.0;
    	gray *= 255.0;
    	
    	float over = getTextureRGB(gray,fXIndex,fYIndex,gray/255.0);
    
    	float red = grad*rgb.r*over*112.0/255.0;
		float green = grad*rgb.g*over*66.0/255.0;
		float blue = grad*rgb.b*over*20.0/255.0;
    	if(red<0.0){
        	red = 0.0;
    	}else if(red>1.0){
        	red = 1.0;
    	}
    	if(green<0.0){
        	green = 0.0;
    	}else if(green>1.0){
        	green = 1.0;
    	}
    	if(blue<0.0){
        	blue = 0.0;
    	}else if(blue>1.0){
        	blue = 1.0;
    	}
    	vec4 effectColor = vec4(red,green,blue,vColor.a);
    	gl_FragColor = initLastParams(vColor,effectColor);
	}else{
		gl_FragColor = vColor;
	}   
}
