precision highp float;
varying vec2 vTextureCoord;
uniform sampler2D sTexture;
uniform float scaleFactor;
uniform float textureSize;
uniform float textureWidth;
uniform float textureHeight;
uniform float fade;
void main() {
	
    vec4 vColor = texture2D(sTexture, vTextureCoord);
    
    float fXIndex = vTextureCoord.x*textureSize;
    float fYIndex = vTextureCoord.y*textureSize;
    
    //float scaleFactor = 1.0;
    
    if( ! ( fYIndex < scaleFactor || fYIndex > textureHeight - scaleFactor || 
            fXIndex < scaleFactor || fXIndex > textureWidth - scaleFactor ))
    {
    	float redXSum = 0.0;
    	float redYSum = 0.0;
    
    	float greenXSum = 0.0;
    	float greenYSum = 0.0;
    
    	float blueXSum = 0.0;
    	float blueYSum = 0.0;
    	
    	float fTempX = ( fXIndex  -scaleFactor + 0.5 ) / textureSize ;
        float fTempY = ( fYIndex  -scaleFactor + 0.5 ) / textureSize ;
        vec4 vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
        
        // X Direction
        redXSum = redXSum -  vTempColor.r;
        greenXSum = greenXSum -  vTempColor.g;
        blueXSum = blueXSum -  vTempColor.b;
        
        // Y Direction
        redYSum = redYSum + vTempColor.r;
        greenYSum = greenYSum + vTempColor.g;
        blueYSum = blueYSum + vTempColor.b;
        
        fTempX = ( fXIndex +scaleFactor + 0.5 ) / textureSize ;
        fTempY = ( fYIndex  -scaleFactor + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
        
        // X Direction
        redXSum = redXSum + vTempColor.r;
        greenXSum = greenXSum + vTempColor.g;
        blueXSum = blueXSum + vTempColor.b;
        
        // Y Direction
        redYSum = redYSum + vTempColor.r;
        greenYSum = greenYSum + vTempColor.g;
        blueYSum = blueYSum + vTempColor.b;
        
        
        fTempX = ( fXIndex -scaleFactor + 0.5 ) / textureSize ;
        fTempY = ( fYIndex  + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
        
        // X Direction
        redXSum = redXSum-2.0*vTempColor.r;
        greenXSum = greenXSum-2.0*vTempColor.g;
        blueXSum = blueXSum-2.0*vTempColor.b;
        
        fTempX = ( fXIndex +scaleFactor + 0.5 ) / textureSize ;
        fTempY = ( fYIndex  + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
        
        // X Direction
        redXSum = redXSum+2.0*vTempColor.r;
        greenXSum = greenXSum+2.0*vTempColor.g;
        blueXSum = blueXSum+2.0*vTempColor.b;
        
        fTempX = ( fXIndex -scaleFactor + 0.5 ) / textureSize ;
        fTempY = ( fYIndex +scaleFactor + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
        
        // X Direction
        redXSum = redXSum - vTempColor.r;
        greenXSum = greenXSum - vTempColor.g;
        blueXSum = blueXSum - vTempColor.b;
        
        // Y Direction
        redYSum = redYSum - vTempColor.r;
        greenYSum = greenYSum - vTempColor.g;
        blueYSum = blueYSum - vTempColor.b;
        
        fTempX = ( fXIndex +scaleFactor + 0.5 ) / textureSize ;
        fTempY = ( fYIndex +scaleFactor + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
        
         // X Direction
        redXSum = redXSum + vTempColor.r;
        greenXSum = greenXSum + vTempColor.g;
        blueXSum = blueXSum + vTempColor.b;
        
        // Y Direction
        redYSum = redYSum - vTempColor.r;
        greenYSum = greenYSum - vTempColor.g;
        blueYSum = blueYSum - vTempColor.b;
        
        fTempX = ( fXIndex  + 0.5 ) / textureSize ;
        fTempY = ( fYIndex -scaleFactor + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
        
        // Y Direction
        redYSum = redYSum + 2.0*vTempColor.r;
        greenYSum = greenYSum + 2.0*vTempColor.g;
        blueYSum = blueYSum + 2.0*vTempColor.b;
        
        fTempX = ( fXIndex  + 0.5 ) / textureSize ;
        fTempY = ( fYIndex +scaleFactor + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
        
        // Y Direction
        redYSum = redYSum - 2.0*vTempColor.r;
        greenYSum = greenYSum - 2.0*vTempColor.g;
        blueYSum = blueYSum - 2.0*vTempColor.b;
        
        float fRedTotalSum = sqrt((redXSum*redXSum+redYSum*redYSum));
        
        float fGreenTotalSum = sqrt((greenXSum*greenXSum+greenYSum*greenYSum));
        
        float fBlueTotalSum = sqrt((blueXSum*blueXSum+blueYSum*blueYSum));
        
        
        float oneFloat = float(1.0);
        float zeroFloat = float(0.0);
        
        if(fRedTotalSum<zeroFloat){
        	fRedTotalSum = zeroFloat;
        }
        
        if(fRedTotalSum>oneFloat){
        	fRedTotalSum = oneFloat;
        }
        
        if(fGreenTotalSum<zeroFloat){
        	fGreenTotalSum = zeroFloat;
        }
        
        if(fGreenTotalSum>oneFloat){
        	fGreenTotalSum = oneFloat;
        }
        
        
        if(fBlueTotalSum<zeroFloat){
        	fBlueTotalSum = zeroFloat;
        }
        
        if(fBlueTotalSum>oneFloat){
        	fBlueTotalSum = oneFloat;
        }
        
        fRedTotalSum = 1.0 - fRedTotalSum;
        fGreenTotalSum = 1.0 - fGreenTotalSum;
        fBlueTotalSum = 1.0 - fBlueTotalSum;
        
        float resultRed = ((100.0-fade)*fRedTotalSum+fade*vColor.r)/100.0;
        float resultGreen = ((100.0-fade)*fGreenTotalSum+fade*vColor.g)/100.0;
        float resultBlue = ((100.0-fade)*fBlueTotalSum+fade*vColor.g)/100.0;
        
        vColor.r = resultRed;
        vColor.g = resultGreen;
        vColor.b = resultBlue;
        
        //vColor = vec4((1.0-fRedTotalSum),(1.0-fGreenTotalSum),(1.0-fBlueTotalSum),vColor.a);
    }
    else
    {
    	vColor.r=1.0;
    	vColor.g = 1.0;
    	vColor.b = 1.0;
    }
    
    gl_FragColor = vColor;
}