precision highp float;
varying vec2 vTextureCoord;
uniform sampler2D sTexture;

uniform float scaleFactor;
uniform float textureSize;
uniform float textureWidth;
uniform float textureHeight;

uniform sampler2D sTexture2;
uniform float texture2Size;
uniform float texture2Width;
uniform float texture2Height;

uniform float fade;
uniform float right;
uniform float leftU;



float getGray(float x,float y){
    if(x<0.0){
        x = 0.0;
    }else if(x>=textureWidth){
        x = textureWidth - 1.0;
    }
    
    if(y<0.0){
        y = 0.0;
    }else if(y>=textureHeight){
        y = textureHeight - 1.0;
    }
    
    x/=textureSize;
    y/=textureSize;
    vec4 vTempColor = texture2D(sTexture, vec2(x,y));
    
    float r = vTempColor.r*255.0;
	float g = vTempColor.g*255.0;
	float b = vTempColor.b*255.0;

	float gray = (r+g+b)/3.0;
    return gray;
}


float saturate_cast(float v){
    if(v<0.0){
        v = 0.0;
    }else{
        if(v>255.0){
            v = 255.0;
        }
    }
    return v;
}

vec4 getTextureRGB(float x,float y){

	float textX = x/textureWidth*texture2Width;
	float textY =  y/textureHeight*texture2Height;
	vec4 color = texture2D(sTexture2, vec2(textX/texture2Size,textY/texture2Size));
	return color;
}

float setupLum(float value){
	float UPPER_BOUND = 128.0;
	if(value<UPPER_BOUND){
		value = 255.0 * value / UPPER_BOUND;
	}else{
		value = 255.0;
	}
	
	return value;
}

float setupRightLuma(float i,float value){
	float result = 0.0;
	if(value<128.0){
		result = 2.0*i*value/256.0;
	}else{
		result = 255.0 - (255.0 - 2.0 * (value - 128.0)) * (255.0 - i) / 256.0;
	}
	return result;
}

void main() {
	vec4 vColor = texture2D(sTexture, vTextureCoord);
	
	float left = leftU;
	if(left>99.0){
		left = 99.0;
	}
	
	
	float left_x = textureWidth * (100.0 - left) / 100.0;
	float left_y = textureHeight * 0.045;
	
	float right_x = textureWidth * right / 100.0;
    float right_y = textureHeight * 0.065;
	

	if(textureSize>0.0 && texture2Size>0.0){
		
		float fXIndex = vTextureCoord.x*textureSize;
    	float fYIndex = vTextureCoord.y*textureSize;
    	
    	float y;
    	float x;
    	
    	vec4 temp;
    	float tempRed;
    	float tempGreen;
    	float tempBlue;
    	
    	float lumRed;
    	float lumGreen;
    	float lumBlue;
    	
		vec4 overlay = getTextureRGB(fXIndex,fYIndex);
		overlay.r = overlay.r*255.0;
		overlay.g = overlay.g*255.0;
		overlay.b = overlay.b*255.0;
		vec4 dest = overlay;
		
		
		
		if(fYIndex>=left_y && fYIndex<textureHeight && fXIndex>=left_x && fXIndex < textureWidth){
			x = fXIndex - left_x;
			y = fYIndex - left_y;
			
			temp = texture2D(sTexture, vec2(x/textureSize,y/textureSize));
			temp.r = temp.r*255.0;
			temp.g = temp.g*255.0;
			temp.b = temp.b*255.0;
			
			lumRed = setupLum(temp.r);
			lumGreen = setupLum(temp.g);
			lumBlue = setupLum(temp.b);
			
			dest.r = dest.r*lumRed/255.0;
			dest.g = dest.g*lumGreen/255.0;
			dest.b = dest.b*lumBlue/255.0;
			
		}  
		
		if(fXIndex < left_x && fYIndex < left_y){
		
			y = fYIndex + textureHeight - left_y;
			x = fXIndex + textureWidth - left_x;
			
			temp = texture2D(sTexture, vec2(x/textureSize,y/textureSize));
			temp.r = temp.r*255.0;
			temp.g = temp.g*255.0;
			temp.b = temp.b*255.0;
			
			lumRed = setupLum(temp.r);
			lumGreen = setupLum(temp.g);
			lumBlue = setupLum(temp.b);
			
			dest.r = dest.r*lumRed/255.0;
			dest.g = dest.g*lumGreen/255.0;
			dest.b = dest.b*lumBlue/255.0;
		
			
		}
		
		if(fYIndex>=left_y && fYIndex<textureHeight && fXIndex < left_x){
			x = fXIndex + textureWidth - left_x;
			y = fYIndex - left_y;
			
			temp = texture2D(sTexture, vec2(x/textureSize,y/textureSize));
			temp.r = temp.r*255.0;
			temp.g = temp.g*255.0;
			temp.b = temp.b*255.0;
			
			lumRed = setupLum(temp.r);
			lumGreen = setupLum(temp.g);
			lumBlue = setupLum(temp.b);
			
			dest.r = dest.r*lumRed/255.0;
			dest.g = dest.g*lumGreen/255.0;
			dest.b = dest.b*lumBlue/255.0;
		}
		
		if(fXIndex>=left_x && fXIndex < textureWidth && fYIndex < left_y){
			x = fXIndex - left_x;
			y = fYIndex + textureHeight - left_y;
			
			temp = texture2D(sTexture, vec2(x/textureSize,y/textureSize));
			temp.r = temp.r*255.0;
			temp.g = temp.g*255.0;
			temp.b = temp.b*255.0;
			
			lumRed = setupLum(temp.r);
			lumGreen = setupLum(temp.g);
			lumBlue = setupLum(temp.b);
			
			dest.r = dest.r*lumRed/255.0;
			dest.g = dest.g*lumGreen/255.0;
			dest.b = dest.b*lumBlue/255.0;
		}
		
		if(right<100.0){
			if(fYIndex>=right_y && fYIndex<textureHeight && fXIndex>=right_x && fXIndex < textureWidth){
				x = fXIndex - right_x;
				y = fYIndex - right_y;
				vec4 src = texture2D(sTexture, vec2(x/textureSize,y/textureSize));
				src.r = src.r*255.0;
				src.g = src.g*255.0;
				src.b = src.b*255.0;
				dest.r = setupRightLuma(src.r,temp.r);
				dest.g = setupRightLuma(src.g,temp.g);
				dest.b = setupRightLuma(src.b,temp.b);
			}
		}
		
		
		
		dest.r = dest.r/255.0;
		dest.g = dest.g/255.0;
		dest.b = dest.b/255.0;
		
		dest = (fade*vColor+(100.0-fade)*dest)/100.0;
		
		if(dest.r<0.0){
			dest.r = 0.0;
		}else if(dest.r>1.0){
			dest.r = 1.0;
		}
		
		if(dest.g<0.0){
			dest.g = 0.0;
		}else if(dest.g>1.0){
			dest.g = 1.0;
		}
		
		if(dest.b<0.0){
			dest.b = 0.0;
		}else if(dest.b>1.0){
			dest.b = 1.0;
		}
		
		gl_FragColor = dest;
		
		
	}else{
		gl_FragColor = vColor;
	}   
}