precision highp float;
varying vec2 vTextureCoord;
uniform sampler2D sTexture;

uniform float scaleFactor;
uniform float textureSize;
uniform float textureWidth;
uniform float textureHeight;

uniform sampler2D sTexture2;
uniform float texture2Size;
uniform float texture2Width;
uniform float texture2Height;

uniform float fade;
uniform float right;
uniform float leftU;

float saturate_cast(float v){
    if(v<0.0){
        v = 0.0;
    }else{
        if(v>255.0){
            v = 255.0;
        }
    }
    return v;
}

vec3 rabidRGBToHSL(vec3 rgb)
            {
            float r = rgb.r;
        	float g = rgb.g;
        	float b = rgb.b;

			float H = 0.0;
			float S = 0.0;
			float L = 0.0;

            float cMax = max(max(r,g),b);
            float cMin = min(min(r,g),b);
            float delta = cMax - cMin;
            if(cMax == r){
                H = mod((g - b)/delta,6.0)*60.0;
            } else if(cMax == g) {
                H = ((b - r)/delta + 2.0)*60.0;
            } else {
                H = ((r - g)/delta + 4.0)*60.0;
            }

            L = (cMax + cMin)/2.0;

            if(delta == 0.0){
                S = 0.0;
            } else {
                S = delta/(1.0 - abs((2.0*L - 1.0)));
            }

            vec3 hsl = vec3(H,S,L);
            return hsl;
            }


	vec3 rabidHSLToRGB(vec3 hsl)
            {


            float H = hsl.x;
        	float S = hsl.y;
        	float L = hsl.z;

        	float C = (1.0 - abs((2.0*L - 1.0))) * S;
        	float X = C * (1.0 - abs( (mod((H / 60.0),2.0) - 1.0)));
        	float m = L - C/2.0;

        	vec3 rgb = vec3(0.0,0.0,0.0);

            if(H >= 0.0 && H <= 60.0){
            	rgb = vec3(C,X,0.0);
            } else if(H >= 60.0 && H <= 120.0){
            	rgb = vec3(X,C,0.0);
            } else if(H >= 120.0 && H <= 180.0){
            	rgb = vec3(0.0,C,X);
			} else if(H >= 180.0 && H <= 240.0){
				rgb = vec3(0.0,X,C);
			} else if(H >= 240.0 && H <= 300.0){
				rgb = vec3(X,0.0,C);
			} else if(H >= 300.0 && H <= 360.0){
				rgb = vec3(C,0.0,X);
			}

            rgb.r += m;
            rgb.g += m;
            rgb.b += m;

            return rgb;

            }

vec3 getRed(float x,float y){
	
	if(x<0.0){
		x = 0.0;
	}else if(x>=textureWidth){
		x = textureWidth-1.0;
	}
	
	if(y<0.0){
		y = 0.0;
	}else if(y>=textureHeight){
		y = textureHeight-1.0;
	}
	
	vec4 color = texture2D(sTexture, vec2(x/textureSize,y/textureSize));
	vec3 hsl = rabidRGBToHSL(color.rgb);
	hsl.x = 0.0;
	hsl.y = 100.0*hsl.y+5.0;
	
	if(hsl.y>100.0){
		hsl.y = 100.0;
	}
	
	hsl.y = hsl.y/100.0;
	
	hsl.z = 100.0*hsl.z-5.0;
	if(hsl.z<0.0){
		hsl.z = 0.0;
	}
	hsl.z = hsl.z/100.0;
	
	vec3 red = rabidHSLToRGB(hsl);
	return red;
}


vec3 getCyan(float x,float y){

	if(x<0.0){
		x = 0.0;
	}else if(x>=textureWidth){
		x = textureWidth-1.0;
	}
	
	if(y<0.0){
		y = 0.0;
	}else if(y>=textureHeight){
		y = textureHeight-1.0;
	}

	vec4 color = texture2D(sTexture, vec2(x/textureSize,y/textureSize));
	vec3 hsl = rabidRGBToHSL(color.rgb);
	hsl.x = 180.0;
	hsl.y = 100.0*hsl.y+5.0;
	
	if(hsl.y>100.0){
		hsl.y = 100.0;
	}
	
	hsl.y = hsl.y/100.0;
	
	vec3 cyan = rabidHSLToRGB(hsl);
	return cyan;
}

float hard(float m,float i){
	float result = 0.0;
	if(m < 128.0){
		result = 2.0 * m * i / 256.0;
	}else{
		result = 255.0 - (255.0 - 2.0 * (m - 128.0)) * (255.0 - i) / 256.0;
	}
	return result;
}

void main() {
	vec4 vColor = texture2D(sTexture, vTextureCoord);
	
	
	if(textureSize>0.0){
		
		float dl = textureWidth * leftU  / 200.0;
    	float dr = textureWidth * right / 200.0;
		
		float fXIndex = vTextureCoord.x*textureSize;
    	float fYIndex = vTextureCoord.y*textureSize;
    	
    	vec4 destColor = vColor;

    	if(fXIndex<dr){
    		vec3 redColor = getRed((fXIndex+dl),fYIndex);
    		redColor.r = 255.0*redColor.r;
    		redColor.g = 255.0*redColor.g;
    		redColor.b = 255.0*redColor.b;
    	
    		vec3 cyan = getCyan((fXIndex+textureWidth-dr),fYIndex);
    		cyan.r = 255.0*cyan.r;
    		cyan.g = 255.0*cyan.g;
    		cyan.b = 255.0*cyan.b;
    	
    		float red = hard(redColor.r,cyan.r);
    		float green = hard(redColor.g,cyan.g);
    		float blue = hard(redColor.b,cyan.b);
    	
    		red = red/255.0;
    		green = green/255.0;
    		blue = blue/255.0;
    		destColor = vec4(red,green,blue,vColor.a);
    	}else if(fXIndex<textureWidth-dl){
    		vec3 redColor = getRed((fXIndex+dl),fYIndex);
    		redColor.r = 255.0*redColor.r;
    		redColor.g = 255.0*redColor.g;
    		redColor.b = 255.0*redColor.b;
    	
    		vec3 cyan = getCyan((fXIndex-dr),fYIndex);
    		cyan.r = 255.0*cyan.r;
    		cyan.g = 255.0*cyan.g;
    		cyan.b = 255.0*cyan.b;
    	
    		float red = hard(redColor.r,cyan.r);
    		float green = hard(redColor.g,cyan.g);
    		float blue = hard(redColor.b,cyan.b);
    	
    		red = red/255.0;
    		green = green/255.0;
    		blue = blue/255.0;
    		destColor = vec4(red,green,blue,vColor.a);
    		
    	}else{
    	
    		vec3 redColor = getRed((fXIndex-textureWidth+dl),fYIndex);
    		redColor.r = 255.0*redColor.r;
    		redColor.g = 255.0*redColor.g;
    		redColor.b = 255.0*redColor.b;
    	
    		vec3 cyan = getCyan((fXIndex-dr),fYIndex);
    		cyan.r = 255.0*cyan.r;
    		cyan.g = 255.0*cyan.g;
    		cyan.b = 255.0*cyan.b;
    	
    		float red = hard(redColor.r,cyan.r);
    		float green = hard(redColor.g,cyan.g);
    		float blue = hard(redColor.b,cyan.b);
    	
    		red = red/255.0;
    		green = green/255.0;
    		blue = blue/255.0;
    		destColor = vec4(red,green,blue,vColor.a);
    	}

    	 vec4 dest = (fade*vColor+(100.0-fade)*destColor)/100.0;
    	 
    	 if(dest.r<0.0){
			dest.r = 0.0;
		 }else if(dest.r>1.0){
			dest.r = 1.0;
		 }
		
		 if(dest.g<0.0){
			dest.g = 0.0;
		 }else if(dest.g>1.0){
			dest.g = 1.0;
		 }
		
		 if(dest.b<0.0){
			dest.b = 0.0;
		 }else if(dest.b>1.0){
			dest.b = 1.0;
		 }
    	 
    	 gl_FragColor = dest;
    	
	}else{
		gl_FragColor = vColor;
	}
	
}