precision highp float;
varying vec2 vTextureCoord;
uniform sampler2D sTexture;
uniform float hue;
uniform float replaceDeltaSaturation;
uniform float fade;

vec3 rabidRGBToHSL(vec3 rgb)
            {
            float r = rgb.r;
        	float g = rgb.g;
        	float b = rgb.b;

			float H = 0.0;
			float S = 0.0;
			float L = 0.0;

            float cMax = max(max(r,g),b);
            float cMin = min(min(r,g),b);
            float delta = cMax - cMin;
            if(cMax == r){
                H = mod((g - b)/delta,6.0)*60.0;
            } else if(cMax == g) {
                H = ((b - r)/delta + 2.0)*60.0;
            } else {
                H = ((r - g)/delta + 4.0)*60.0;
            }

            L = (cMax + cMin)/2.0;

            if(delta == 0.0){
                S = 0.0;
            } else {
                S = delta/(1.0 - abs((2.0*L - 1.0)));
            }

            vec3 hsl = vec3(H,S,L);
            return hsl;
            }


	vec3 rabidHSLToRGB(vec3 hsl)
            {


            float H = hsl.x;
        	float S = hsl.y;
        	float L = hsl.z;

        	float C = (1.0 - abs((2.0*L - 1.0))) * S;
        	float X = C * (1.0 - abs( (mod((H / 60.0),2.0) - 1.0)));
        	float m = L - C/2.0;

        	vec3 rgb = vec3(0.0,0.0,0.0);

            if(H >= 0.0 && H <= 60.0){
            	rgb = vec3(C,X,0.0);
            } else if(H >= 60.0 && H <= 120.0){
            	rgb = vec3(X,C,0.0);
            } else if(H >= 120.0 && H <= 180.0){
            	rgb = vec3(0.0,C,X);
			} else if(H >= 180.0 && H <= 240.0){
				rgb = vec3(0.0,X,C);
			} else if(H >= 240.0 && H <= 300.0){
				rgb = vec3(X,0.0,C);
			} else if(H >= 300.0 && H <= 360.0){
				rgb = vec3(C,0.0,X);
			}

            rgb.r += m;
            rgb.g += m;
            rgb.b += m;

            return rgb;

            }

void main() {
    vec4 color = texture2D(sTexture, vTextureCoord);
    
    vec3 HSL = rabidRGBToHSL(color.rgb);
    
    //float hue = 250.0;
    //float replaceDeltaSaturation = 20.0;
    
    float saturation = HSL.g;
    
    saturation += replaceDeltaSaturation/50.0;
    
    if(saturation>1.0){
        saturation = 1.0;
    }else{
        if(saturation<0.0){
            saturation = 0.0;
        }
    }
    
    HSL.r = hue;
    HSL.g = saturation;
    vec3 RGB = rabidHSLToRGB(HSL);
    vec4 destColor = vec4(RGB.r,RGB.g,RGB.b,1.0);
    
    gl_FragColor = (fade*color+(100.0-fade)*destColor)/100.0;
}