precision highp float;
varying vec2 vTextureCoord;
uniform sampler2D sTexture;

uniform float brightness;
uniform float contrast;
uniform float fade;

float saturate_cast(float v){
    if(v<0.0){
        v = 0.0;
    }else{
        if(v>255.0){
            v = 255.0;
        }
    }
    return v;
}

void main(){
	vec4 color = texture2D(sTexture, vTextureCoord);;
	
	
	vec4 origColor = color;
    
    mat3 koeffs = mat3(-0.00044460205,	0.65847158,	66,
							-0.0019713987,		1.408589,	0,
							-0.0049211006,		2.7067721,	-111.83952);
    
    float red = color.r*255.0;
    float green = color.g*255.0;
    float blue = color.b*255.0;
    
    float r = koeffs[2][0]*red*red + koeffs[2][1]*red + koeffs[2][2];
	float g = koeffs[1][0]*green*green + koeffs[1][1]*green + koeffs[1][2];
    float b = koeffs[0][0]*blue*blue + koeffs[0][1]*blue + koeffs[0][2];
    
    float lut_r = saturate_cast(((r-128.0)*contrast/50.0 + 128.0)*brightness/50.0);
    float lut_g = saturate_cast(((g-128.0)*contrast/50.0 + 128.0)*brightness/50.0);
    float lut_b = saturate_cast(((b-128.0)*contrast/50.0 + 128.0)*brightness/50.0);
    
    
    color.r = lut_r/255.0;
    color.g = lut_g/255.0;
    color.b = lut_b/255.0;
    
    color = (fade*origColor+(100.0-fade)*color)/100.0;
    
    if(color.r<0.0){
		color.r = 0.0;
	}else if(color.r>1.0){
		color.r = 1.0;
	}
		
	if(color.g<0.0){
		color.g = 0.0;
	}else if(color.g>1.0){
		color.g = 1.0;
	}
		
	if(color.b<0.0){
		color.b = 0.0;
	}else if(color.b>1.0){
		color.b = 1.0;
	}
    
    gl_FragColor = color;
}