precision highp float;
varying vec2 vTextureCoord;
uniform sampler2D sTexture;
uniform float scaleFactor;
uniform float textureSize;
uniform float textureWidth;
uniform float textureHeight;



uniform float vignette;
uniform float contrast;
uniform float amount;
uniform int mode_r;
uniform int mode_g;
uniform int mode_b;



float saturate_cast(float v){
    if(v<0.0){
        v = 0.0;
    }else{
        if(v>255.0){
            v = 255.0;
        }
    }
    return v;
}

float getValueWithCorrector(int mode,float amount,float value){
	float scale = 1.0;
	if(mode == 0){
		scale = 1.0 - amount;
		value = (scale * value + 32.0 * (1.0 - scale));
	}else if(mode == 2){
		scale = 1.0 / (1.0 + 2.0 * amount);
		
		if(value < 128.0){
			value = 128.0 * pow(value / 128.0, scale);
		}else{
			value = 256.0 - 128.0 * pow((2.0 - value / 128.0), scale);
		}
	
	}else if(mode == 5){
		scale = 1.0 + 2.0 * amount;
		
		if(value < 128.0){
			value = 128.0 * pow(value / 128.0, scale);
		}else{
			value = 256.0 - 128.0 * pow((2.0 - value / 128.0), scale);
		}
	}
	
	return value;
}

void main(){
	vec4 color = texture2D(sTexture, vTextureCoord);
	
	
	if(textureSize>0.0){
	
		float red = color.r*255.0;
		float green = color.g*255.0;
		float blue = color.b*255.0;
		
		//int mode_r = 2;
    	//int mode_g = 5;
    	//int mode_b = 2;
    	
    	float b = 255.0* (1.0 - contrast / 2.0);
    	float a = 255.0 - b;
    	
    	float m = 0.0;
    	
    	if(red<a){
    		red = getValueWithCorrector(mode_r,amount,0.0);
    	}else if(red>=a && red<=b){
    		m = 255.0 * (red - a) / (b - a);
    		red = getValueWithCorrector(mode_r,amount,m);
    	}else{
    		red = getValueWithCorrector(mode_r,amount,255.0);
    	}
    	
    	if(green<a){
    		green = getValueWithCorrector(mode_g,amount,0.0);
    	}else if(green>=a && green<=b){
    		m = 255.0 * (green - a) / (b - a);
    		green = getValueWithCorrector(mode_g,amount,m);
    	}else{
    		green = getValueWithCorrector(mode_g,amount,255.0);
    	}
    	
    	if(blue<a){
    		blue = getValueWithCorrector(mode_b,amount,0.0);
    	}else if(blue>=a && blue<=b){
    		m = 255.0 * (blue - a) / (b - a);
    		blue = getValueWithCorrector(mode_b,amount,m);
    	}else{
    		blue = getValueWithCorrector(mode_b,amount,255.0);
    	}
    	
    	float vignette1 = vignette/scaleFactor;
    	
    	float distX = (vTextureCoord.x-textureWidth/2.0/textureSize);
    	float distY = (vTextureCoord.y-textureHeight/2.0/textureSize);
    	
    	vec2 dist = vec2(distX,distY);
    	dist.x = 1.0 - dot(dist, dist);
    	
    	
    	
    	float v = pow(dist.x, vignette1);
    	
        if(v<0.0){
    		v = 0.0;
    	}else if(v>1.0){
    		v = 1.0;
    	}
    	
    	red = red*v;
    	green = green*v;
    	blue = blue*v;
    	
    	
    	red = saturate_cast(red);
    	green = saturate_cast(green);
    	blue = saturate_cast(blue);
    	
    	red = red/255.0;
		green = green/255.0;
		blue = blue/255.0;
		
		
		
		gl_FragColor = vec4(red,green,blue,color.a);
	
	}else{
		gl_FragColor = color;
	}
    
}