precision highp float;
varying vec2 vTextureCoord;
uniform sampler2D sTexture;

uniform float textureSize;
uniform float textureWidth;
uniform float textureHeight;
uniform int mode;

void main() {
	float fXIndex = vTextureCoord.x*textureSize;
 	float fYIndex = vTextureCoord.y*textureSize;
 	vec4 destColor;
 	if(mode == 0){
 			if(fXIndex <= textureWidth/2.0){
 				destColor = texture2D(sTexture, vTextureCoord);
 		}else{
 			fXIndex = textureWidth - fXIndex;
 			fXIndex = fXIndex/textureSize;
 			destColor = texture2D(sTexture, vec2(fXIndex,vTextureCoord.y));
 		}
 	}else{
 		if(fYIndex <= textureHeight/2.0){
 			destColor = texture2D(sTexture, vTextureCoord);
 		}else{
 			fYIndex = textureHeight - fYIndex;
 			fYIndex = fYIndex/textureSize;
 			destColor = texture2D(sTexture, vec2(vTextureCoord.x,fYIndex));
 		}
 	}
 	
    gl_FragColor = destColor;
}