precision highp float;
varying vec2 vTextureCoord;
uniform sampler2D sTexture;

uniform float scaleFactor;
uniform float textureSize;
uniform float textureWidth;
uniform float textureHeight;

uniform float fade;
uniform float contrast;
uniform float brightness;
uniform float lines;



float getGray(float x,float y){
    if(x<0.0){
        x = 0.0;
    }else if(x>=textureWidth){
        x = textureWidth - 1.0;
    }
    
    if(y<0.0){
        y = 0.0;
    }else if(y>=textureHeight){
        y = textureHeight - 1.0;
    }
    
    x/=textureSize;
    y/=textureSize;
    vec4 vTempColor = texture2D(sTexture, vec2(x,y));
    
    float r = vTempColor.r*255.0;
	float g = vTempColor.g*255.0;
	float b = vTempColor.b*255.0;

	float gray = (r+g+b)/3.0;
    return gray;
}


float saturate_cast(float v){
    if(v<0.0){
        v = 0.0;
    }else{
        if(v>255.0){
            v = 255.0;
        }
    }
    return v;
}

vec3 RGBtoYUV(vec3 rgb){
	vec3 yuv = vec3(0.0,0.0,0.0);
	
	float red = rgb.r*255.0;
	float green = rgb.g*255.0;
	float blue = rgb.b*255.0;
	
	float y = 0.299*red + 0.587*green + 0.114*blue;
	float u = (blue-y)*0.565;
	float v = (red-y)*0.713;
	yuv.r = y;
	yuv.g = u;
	yuv.b = v;
	
	/*Y = 0.299R + 0.587G + 0.114B

U'= (B-Y)*0.565

V'= (R-Y)*0.713*/
	
	return yuv;
}

vec3 YUVtoRGB(vec3 yuv){
	vec3 rgb = vec3(0.0,0.0,0.0);
	rgb.r = yuv.x + 1.403*yuv.z;
	rgb.g = yuv.x - 0.344*yuv.y - 0.714*yuv.z;
	rgb.b = yuv.x + 1.770*yuv.y;
	rgb.r/=255.0;
	rgb.g/=255.0;
	rgb.b/=255.0;
	
	/*
	R = Y + 1.403V'

G = Y - 0.344U' - 0.714V'

B = Y + 1.770U'
	
	*/
	
	return rgb;
}



void main() {
	vec4 vColor = texture2D(sTexture, vTextureCoord);

	if(textureSize>0.0){
		float fXIndex = vTextureCoord.x*textureSize;
    	float fYIndex = vTextureCoord.y*textureSize;

    	float tl = getGray(fXIndex-scaleFactor,fYIndex-scaleFactor);
    	float l =   getGray(fXIndex-scaleFactor,fYIndex);
    	float bl =  getGray(fXIndex-scaleFactor,fYIndex+scaleFactor);
    	float t =   getGray(fXIndex,fYIndex-scaleFactor);
    	float b =  getGray(fXIndex,fYIndex+scaleFactor);
    	float tr =  getGray(fXIndex+scaleFactor,fYIndex-scaleFactor);
    	float r =   getGray(fXIndex+scaleFactor,fYIndex);
    	float br =  getGray(fXIndex+scaleFactor,fYIndex+scaleFactor);
   
    	float dX = -tl - 2.0*l - bl + tr + 2.0*r + br;
    	float dY = -tl - 2.0*t - tr + bl + 2.0*b + br;
    	float grad = abs(dX) + abs(dY);
    	
    	float sobel = grad*2.0*lines/100.0;
    	sobel = saturate_cast(sobel);
    	sobel /= 255.0;
    	
    	vec3 yuv = RGBtoYUV(vColor.rgb);
    	yuv.x = ((yuv.x * 256.0 / 64.0)-0.5);
    	yuv.x = ceil(yuv.x);
    	yuv.x *= 64.0;
    	yuv.x /= 256.0;
    	
    	vec3 rgb = YUVtoRGB(yuv);
    	rgb.r = rgb.r*contrast/50.0 + 0.5;
    	rgb.g = rgb.g*contrast/50.0 + 0.5;
    	rgb.b = rgb.b*contrast/50.0 + 0.5;
    	
    
    	float red = rgb.r*sobel*brightness/50.0;
		float green = rgb.g*sobel*brightness/50.0;
		float blue = rgb.b*sobel*brightness/50.0;
    	if(red<0.0){
        	red = 0.0;
    	}else if(red>1.0){
        	red = 1.0;
    	}
    	if(green<0.0){
        	green = 0.0;
    	}else if(green>1.0){
        	green = 1.0;
    	}
    	if(blue<0.0){
        	blue = 0.0;
    	}else if(blue>1.0){
        	blue = 1.0;
    	}
    	
    	red = (vColor.r*fade+red*(100.0-fade))/100.0;
    	green = (vColor.g*fade+green*(100.0-fade))/100.0;
    	blue = (vColor.b*fade+blue*(100.0-fade))/100.0;
    	
    	gl_FragColor = vec4(red,green,blue,vColor.a);
	}else{
		gl_FragColor = vColor;
	}   
}
