precision highp float;
varying vec2 vTextureCoord;
uniform sampler2D sTexture;

uniform float scaleFactor;
uniform float textureSize;
uniform float textureWidth;
uniform float textureHeight;

uniform sampler2D sTexture2;
uniform float texture2Size;
uniform float texture2Width;
uniform float texture2Height;

uniform float fade;
uniform float contrast;
uniform float brightness;

float getGray(float x,float y){
    if(x<0.0){
        x = 0.0;
    }else if(x>=textureWidth){
        x = textureWidth - 1.0;
    }
    
    if(y<0.0){
        y = 0.0;
    }else if(y>=textureHeight){
        y = textureHeight - 1.0;
    }
    
    x/=textureSize;
    y/=textureSize;
    vec4 vTempColor = texture2D(sTexture, vec2(x,y));
    
    float r = vTempColor.r*255.0;
	float g = vTempColor.g*255.0;
	float b = vTempColor.b*255.0;

	float gray = (r+g+b)/3.0;
    return gray;
}



float saturate_cast(float v,float maxValue){
    if(v<0.0){
        v = 0.0;
    }else{
        if(v>maxValue){
            v = maxValue;
        }
    }
    return v;
}

float getTextureRGB(float gray,float x,float y,float defaultValue){
    float value = defaultValue;
    float halfsize = texture2Width/2.0;
	float textX = x/textureWidth*halfsize;
	float textY =  y/textureHeight*halfsize;
    
    
    
    if ( gray < 26.0 )
	    {
			textX += halfsize;
			textY += halfsize;
	    }else
	    if ( (gray >= 77.0  ) && (gray < 128.0) )
	    {
	    	textY += halfsize;
	    }else
	    if ( (gray >= 128.0 ) && (gray < 179.0) )
	    {
	    	textX += halfsize;
	    }
	    else if(gray > 255.0){
	    
	    	
	    }
	    
        
		if(textX>=texture2Width){
			textX = texture2Width-1.0;
		}
		if(textY>=texture2Height){
			textY = texture2Height-1.0;
		}
        vec4 color = texture2D(sTexture2, vec2(textX/texture2Size,textY/texture2Size));
        value = (color.r+color.g+color.b)/3.0;
    
    return value;
}


vec4 initLastParams(vec4 srcColor,vec4 effectColor){
     effectColor.r-=0.5;
     effectColor.g-=0.5;
     effectColor.b-=0.5;
     effectColor *= (contrast/50.0);
     effectColor.r+=0.5;
     effectColor.g+=0.5;
     effectColor.b+=0.5;
     effectColor *= (brightness/50.0);
     
     effectColor.r = saturate_cast(effectColor.r,1.0);
     effectColor.g = saturate_cast(effectColor.g,1.0);
     effectColor.b = saturate_cast(effectColor.b,1.0);
     
     effectColor = (50.0*srcColor+50.0*effectColor)/100.0;
     
     vec4 destColor = (fade*srcColor+(100.0-fade)*effectColor)/100.0;
     
     return destColor;
}

void main() {
	vec4 vColor = texture2D(sTexture, vTextureCoord);
	
	
	if(textureSize>0.0 && texture2Size>0.0 && texture2Width>0.0 && texture2Height>0.0){
		float fXIndex = vTextureCoord.x*textureSize;
    	float fYIndex = vTextureCoord.y*textureSize;

    	float tl = getGray(fXIndex-scaleFactor,fYIndex-scaleFactor);
    	float l =   getGray(fXIndex-scaleFactor,fYIndex);
    	float bl =  getGray(fXIndex-scaleFactor,fYIndex+scaleFactor);
    	float t =   getGray(fXIndex,fYIndex-scaleFactor);
    	float b =  getGray(fXIndex,fYIndex+scaleFactor);
    	float tr =  getGray(fXIndex+scaleFactor,fYIndex-scaleFactor);
    	float r =   getGray(fXIndex+scaleFactor,fYIndex);
    	float br =  getGray(fXIndex+scaleFactor,fYIndex+scaleFactor);
   
    	float dX = -tl - 2.0*l - bl + tr + 2.0*r + br;
    	float dY = -tl - 2.0*t - tr + bl + 2.0*b + br;
    	float grad = abs(dX) + abs(dY);
    	if(grad<0.0){
			grad = 0.0;
    	}else if(grad>255.0){
			grad = 255.0;
		}
    	grad =255.0 - (grad*(255.0-grad)+128.0*grad)/255.0;
    
    	if(grad<0.0){
        	grad = 0.0;
    	}else if(grad>255.0){
       	grad = 255.0; 
    	}
    
    	grad/=255.0;
    	
    	float gray = (vColor.r+vColor.g+vColor.b)*255.0/3.0;
    	
    	float strokeValue = getTextureRGB(gray,fXIndex,fYIndex,gray/255.0);
    	float red = grad*strokeValue;
		float green = grad*strokeValue;
		float blue = grad*strokeValue;
    	if(red<0.0){
        	red = 0.0;
    	}else if(red>1.0){
        	red = 1.0;
    	}
    	if(green<0.0){
        	green = 0.0;
    	}else if(green>1.0){
        	green = 1.0;
    	}
    	if(blue<0.0){
        	blue = 0.0;
    	}else if(blue>1.0){
        	blue = 1.0;
    	}
    
    	
    	vec4 effectColor = vec4(red,green,blue,vColor.a);
    	vec4 destColor = initLastParams(vColor,effectColor);
    	if(destColor.r<0.0){
    		destColor.r = 0.0;
    	}else if(destColor.r>1.0){
    		destColor.r = 1.0;
    	}
    	
    	if(destColor.g<0.0){
    		destColor.g = 0.0;
    	}else if(destColor.g>1.0){
    		destColor.g = 1.0;
    	}
    	
    	if(destColor.b<0.0){
    		destColor.b = 0.0;
    	}else if(destColor.b>1.0){
    		destColor.b = 1.0;
    	}
    	
    	gl_FragColor = destColor;
    	
	}else{
		gl_FragColor = vColor;
	}    
}