precision highp float;
varying vec2 vTextureCoord;
uniform sampler2D sTexture;

uniform float scaleFactor;
uniform float textureSize;
uniform float textureWidth;
uniform float textureHeight;

uniform float fade;
uniform float deltaHue;
uniform float deltaSaturation;
uniform float deltaLightness;

vec3 rabidRGBToHSL(vec3 rgb)
            {
            float r = rgb.r;
        	float g = rgb.g;
        	float b = rgb.b;

			float H = 0.0;
			float S = 0.0;
			float L = 0.0;

            float cMax = max(max(r,g),b);
            float cMin = min(min(r,g),b);
            float delta = cMax - cMin;
            if(cMax == r){
                H = mod((g - b)/delta,6.0)*60.0;
            } else if(cMax == g) {
                H = ((b - r)/delta + 2.0)*60.0;
            } else {
                H = ((r - g)/delta + 4.0)*60.0;
            }

            L = (cMax + cMin)/2.0;

            if(delta == 0.0){
                S = 0.0;
            } else {
                S = delta/(1.0 - abs((2.0*L - 1.0)));
            }

            vec3 hsl = vec3(H,S,L);
            return hsl;
            }


	vec3 rabidHSLToRGB(vec3 hsl)
            {


            float H = hsl.x;
        	float S = hsl.y;
        	float L = hsl.z;

        	float C = (1.0 - abs((2.0*L - 1.0))) * S;
        	float X = C * (1.0 - abs( (mod((H / 60.0),2.0) - 1.0)));
        	float m = L - C/2.0;

        	vec3 rgb = vec3(0.0,0.0,0.0);

            if(H >= 0.0 && H <= 60.0){
            	rgb = vec3(C,X,0.0);
            } else if(H >= 60.0 && H <= 120.0){
            	rgb = vec3(X,C,0.0);
            } else if(H >= 120.0 && H <= 180.0){
            	rgb = vec3(0.0,C,X);
			} else if(H >= 180.0 && H <= 240.0){
				rgb = vec3(0.0,X,C);
			} else if(H >= 240.0 && H <= 300.0){
				rgb = vec3(X,0.0,C);
			} else if(H >= 300.0 && H <= 360.0){
				rgb = vec3(C,0.0,X);
			}

            rgb.r += m;
            rgb.g += m;
            rgb.b += m;

            return rgb;

            }

void main() {
	vec4 vColor = texture2D(sTexture, vTextureCoord);
	
	float redSum =  vColor.r;
 	float greenSum =  vColor.g;
 	float blueSum =  vColor.b;
   
    float fXIndex = vTextureCoord.x*textureSize;
    float fYIndex = vTextureCoord.y*textureSize;
   
    if( ! ( fYIndex < scaleFactor || fYIndex > textureHeight - scaleFactor || 
            fXIndex < scaleFactor || fXIndex > textureWidth - scaleFactor ))
    {
    	float redXSum = 0.0;
        float redYSum = 0.0;
    
        float greenXSum = 0.0;
        float greenYSum = 0.0;
    
        float blueXSum = 0.0;
        float blueYSum = 0.0;
        
        float fTempX = ( fXIndex  -scaleFactor + 0.5 ) / textureSize ;
        float fTempY = ( fYIndex  -scaleFactor + 0.5 ) / textureSize ;
        vec4 vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
    	redSum += vTempColor.r;
    	greenSum += vTempColor.g;
    	blueSum += vTempColor.b;
        
        // X Direction
        redXSum = redXSum -  vTempColor.r;
        greenXSum = greenXSum -  vTempColor.g;
        blueXSum = blueXSum -  vTempColor.b;
        
        // Y Direction
        redYSum = redYSum + vTempColor.r;
        greenYSum = greenYSum + vTempColor.g;
        blueYSum = blueYSum + vTempColor.b;
        
        fTempX = ( fXIndex +scaleFactor + 0.5 ) / textureSize ;
        fTempY = ( fYIndex  -scaleFactor + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
    	redSum += vTempColor.r;
    	greenSum += vTempColor.g;
    	blueSum += vTempColor.b;
        
        // X Direction
        redXSum = redXSum + vTempColor.r;
        greenXSum = greenXSum + vTempColor.g;
        blueXSum = blueXSum + vTempColor.b;
        
        // Y Direction
        redYSum = redYSum + vTempColor.r;
        greenYSum = greenYSum + vTempColor.g;
        blueYSum = blueYSum + vTempColor.b;
        
        fTempX = ( fXIndex -scaleFactor + 0.5 ) / textureSize ;
        fTempY = ( fYIndex  + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
    	redSum += vTempColor.r;
    	greenSum += vTempColor.g;
    	blueSum += vTempColor.b;
        
        // X Direction
        redXSum = redXSum-2.0*vTempColor.r;
        greenXSum = greenXSum-2.0*vTempColor.g;
        blueXSum = blueXSum-2.0*vTempColor.b;
        
        fTempX = ( fXIndex +scaleFactor + 0.5 ) / textureSize ;
        fTempY = ( fYIndex  + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
    	redSum += vTempColor.r;
    	greenSum += vTempColor.g;
   	 	blueSum += vTempColor.b;
        
        // X Direction
        redXSum = redXSum+2.0*vTempColor.r;
        greenXSum = greenXSum+2.0*vTempColor.g;
        blueXSum = blueXSum+2.0*vTempColor.b;
        
        
        fTempX = ( fXIndex -scaleFactor + 0.5 ) / textureSize ;
        fTempY = ( fYIndex +scaleFactor + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
    	redSum += vTempColor.r;
    	greenSum += vTempColor.g;
    	blueSum += vTempColor.b;
        
        // X Direction
        redXSum = redXSum - vTempColor.r;
        greenXSum = greenXSum - vTempColor.g;
        blueXSum = blueXSum - vTempColor.b;
        
        // Y Direction
        redYSum = redYSum - vTempColor.r;
        greenYSum = greenYSum - vTempColor.g;
        blueYSum = blueYSum - vTempColor.b;
        
        
        fTempX = ( fXIndex +scaleFactor + 0.5 ) / textureSize ;
        fTempY = ( fYIndex +scaleFactor + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
    	redSum += vTempColor.r;
    	greenSum += vTempColor.g;
    	blueSum += vTempColor.b;
        
         // X Direction
        redXSum = redXSum + vTempColor.r;
        greenXSum = greenXSum + vTempColor.g;
        blueXSum = blueXSum + vTempColor.b;
        
        // Y Direction
        redYSum = redYSum - vTempColor.r;
        greenYSum = greenYSum - vTempColor.g;
        blueYSum = blueYSum - vTempColor.b;
        
        
        fTempX = ( fXIndex  + 0.5 ) / textureSize ;
        fTempY = ( fYIndex -scaleFactor + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
    	redSum += vTempColor.r;
    	greenSum += vTempColor.g;
    	blueSum += vTempColor.b;
        
        // Y Direction
        redYSum = redYSum + 2.0*vTempColor.r;
        greenYSum = greenYSum + 2.0*vTempColor.g;
        blueYSum = blueYSum + 2.0*vTempColor.b;
        
        fTempX = ( fXIndex  + 0.5 ) / textureSize ;
        fTempY = ( fYIndex +scaleFactor + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
    	redSum += vTempColor.r;
    	greenSum += vTempColor.g;
    	blueSum += vTempColor.b;
        
        // Y Direction
        redYSum = redYSum - 2.0*vTempColor.r;
        greenYSum = greenYSum - 2.0*vTempColor.g;
        blueYSum = blueYSum - 2.0*vTempColor.b;
        
        /*float fRedTotalSum = sqrt((redXSum*redXSum+redYSum*redYSum));
        
        float fGreenTotalSum = sqrt((greenXSum*greenXSum+greenYSum*greenYSum));
        
        float fBlueTotalSum = sqrt((blueXSum*blueXSum+blueYSum*blueYSum));
        
        
        float oneFloat = float(1.0);
        float zeroFloat = float(0.0);
        
        if(fRedTotalSum<zeroFloat){
        	fRedTotalSum = zeroFloat;
        }
        
        if(fRedTotalSum>oneFloat){
        	fRedTotalSum = oneFloat;
        }
        
        if(fGreenTotalSum<zeroFloat){
        	fGreenTotalSum = zeroFloat;
        }
        
        if(fGreenTotalSum>oneFloat){
        	fGreenTotalSum = oneFloat;
        }
        
        
        if(fBlueTotalSum<zeroFloat){
        	fBlueTotalSum = zeroFloat;
        }
        
        if(fBlueTotalSum>oneFloat){
        	fBlueTotalSum = oneFloat;
        }
        
        
        fRedTotalSum = 1.0 - fRedTotalSum;
        fGreenTotalSum = 1.0 - fGreenTotalSum;
        fBlueTotalSum = 1.0 - fBlueTotalSum;*/
        
        //**************
        
        float red = redSum/9.0;
        float green = greenSum/9.0;
        float blue = blueSum/9.0;
        
        
        vec3 HSL = rabidRGBToHSL(vec3(red,green,blue));
        
        float hue = HSL.r;
 
 
 		if(hue>=(360.0-deltaHue) || hue<=deltaHue){
    		hue = 0.0;
 		}else{
 			hue = hue/deltaHue;
    		float index = floor(hue);
    		float minHue = index*deltaHue;
    		float maxHue = minHue+deltaHue;
    		hue = (minHue+maxHue)/2.0;
 		}

 
 		HSL.r = hue;
 
 		
 		float saturation = HSL.g*100.0;
		saturation = saturation/deltaSaturation;

 		float saturationIndex = floor(saturation);
 		float minSaturation = saturationIndex*deltaSaturation;
 		float maxSaturation = minSaturation+deltaSaturation;
 
 		saturation = (minSaturation+maxSaturation)/2.0;

 
 		if(saturation>100.0){
    		saturation = 100.0;
 		}
 
 		HSL.g = saturation/100.0;
 
 		float lightness = HSL.b*100.0;
 		lightness = lightness/deltaLightness;
 
 		float lightnessIndex = floor(lightness);
 		float minLightness = lightnessIndex*deltaLightness;
 		float maxLightness = minLightness+deltaLightness;
 
 		lightness = (minLightness+maxLightness)/2.0;
 
 		if(lightness>100.0){
    		lightness = 100.0;
 		}
 
 		HSL.b = lightness/100.0;
        
        vec3 RGB = rabidHSLToRGB(HSL);
        
        vColor.r = RGB.r;
        vColor.g = RGB.g;
        vColor.b = RGB.b;
    
        
        
        
    }
	
    gl_FragColor = vColor;
}