precision highp float;
varying vec2 vTextureCoord;
uniform sampler2D sTexture;

uniform float scaleFactor;
uniform float textureSize;
uniform float textureWidth;
uniform float textureHeight;

uniform float radiusPercent;
uniform float angle;

/*vec4 postFX(sampler2D tex, vec2 uv)
{
  float radius = min(textureWidth,textureHeight)/2.0*radiusPercent/100.0;
  vec2 center = vec2(textureWidth,textureHeight)/2.0;
  vec2 texSize = vec2(textureSize, textureSize);
  vec2 tc = uv * texSize;
  tc -= center;
  float dist = length(tc);
  
  if (dist < radius) 
  {
    float percent = (radius - dist) / radius;
    float theta = percent * percent * angle * 8.0;
    float s = sin(theta);
    float c = cos(theta);
    tc = vec2(dot(tc, vec2(c, -s)), dot(tc, vec2(s, c)));
  }
  
  tc += center;
  vec3 color =  texture2D(tex, tc / texSize).rgb;
  return vec4(color, 1.0);
}*/

void main() {
	float radius = min(textureWidth,textureHeight)/2.0*radiusPercent/100.0;
  vec2 center = vec2(textureWidth,textureHeight)/2.0;
  vec2 texSize = vec2(textureSize, textureSize);
  vec2 tc = vTextureCoord * texSize;
  tc -= center;
  float dist = length(tc);
  
  if (dist < radius) 
  {
    float percent = (radius - dist) / radius;
    float theta = percent * percent * angle * 8.0;
    float s = sin(theta);
    float c = cos(theta);
    tc = vec2(dot(tc, vec2(c, -s)), dot(tc, vec2(s, c)));
  }
  tc += center;
	gl_FragColor = texture2D(sTexture, tc / texSize);
        //gl_FragColor = postFX(sTexture, vTextureCoord);
}