precision highp float;
varying vec2 vTextureCoord;
uniform sampler2D sTexture;
uniform float scaleFactor;
uniform float textureSize;
uniform float textureWidth;
uniform float textureHeight;
uniform int mode;
uniform float fade;
void main() {
	
    vec4 vColor = texture2D(sTexture, vTextureCoord);
    
    float fXIndex = vTextureCoord.x*textureSize;
    float fYIndex = vTextureCoord.y*textureSize;

    mat3 convolutionMatrix = mat3(  -1.0, -1.0, -1.0,
      -1.0,  9.0, -1.0,
      -1.0, -1.0, -1.0);
   
    //int mode = 0;
    
    if(mode == 1){
    	convolutionMatrix = mat3( -2.0, -1.0,  0.0,
       -1.0,  1.0,  1.0,
        0.0,  1.0,  2.0);
    }
    
    if( ! ( fYIndex < scaleFactor || fYIndex > textureHeight - scaleFactor || 
            fXIndex < scaleFactor || fXIndex > textureWidth - scaleFactor ))
    {
    	float redXSum = vColor.r*convolutionMatrix[1][1];
    	//float redYSum = 0.0;
    
    	float greenXSum = vColor.g*convolutionMatrix[1][1];
    	//float greenYSum = 0.0;
    
    	float blueXSum = vColor.b*convolutionMatrix[1][1];
    	//float blueYSum = 0.0;
    	
    	float fTempX = ( fXIndex  -scaleFactor + 0.5 ) / textureSize ;
        float fTempY = ( fYIndex  -scaleFactor + 0.5 ) / textureSize ;
        vec4 vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
        
        // X Direction
        redXSum = redXSum + convolutionMatrix[0][0]*vTempColor.r;
        greenXSum = greenXSum + convolutionMatrix[0][0]*vTempColor.g;
        blueXSum = blueXSum +  convolutionMatrix[0][0]*vTempColor.b;
        
        fTempX = ( fXIndex +scaleFactor + 0.5 ) / textureSize ;
        fTempY = ( fYIndex  -scaleFactor + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
        
        // X Direction
        redXSum = redXSum + convolutionMatrix[0][2]*vTempColor.r;
        greenXSum = greenXSum + convolutionMatrix[0][2]*vTempColor.g;
        blueXSum = blueXSum + convolutionMatrix[0][2]*vTempColor.b;
        
        fTempX = ( fXIndex -scaleFactor + 0.5 ) / textureSize ;
        fTempY = ( fYIndex  + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
        
        // X Direction
        redXSum = redXSum+convolutionMatrix[1][0]*vTempColor.r;
        greenXSum = greenXSum+convolutionMatrix[1][0]*vTempColor.g;
        blueXSum = blueXSum+convolutionMatrix[1][0]*vTempColor.b;
        
        fTempX = ( fXIndex +scaleFactor + 0.5 ) / textureSize ;
        fTempY = ( fYIndex  + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
        
        // X Direction
        redXSum = redXSum+convolutionMatrix[1][2]*vTempColor.r;
        greenXSum = greenXSum+convolutionMatrix[1][2]*vTempColor.g;
        blueXSum = blueXSum+convolutionMatrix[1][2]*vTempColor.b;
        
        fTempX = ( fXIndex -scaleFactor + 0.5 ) / textureSize ;
        fTempY = ( fYIndex +scaleFactor + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
        
        // X Direction
        redXSum = redXSum +convolutionMatrix[2][0]*vTempColor.r;
        greenXSum = greenXSum +convolutionMatrix[2][0]*vTempColor.g;
        blueXSum = blueXSum + +convolutionMatrix[2][0]*vTempColor.b;
        
        fTempX = ( fXIndex +scaleFactor + 0.5 ) / textureSize ;
        fTempY = ( fYIndex +scaleFactor + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
        
         // X Direction
        redXSum = redXSum +convolutionMatrix[2][2]*vTempColor.r;
        greenXSum = greenXSum +convolutionMatrix[2][2]*vTempColor.g;
        blueXSum = blueXSum +convolutionMatrix[2][2]*vTempColor.b;
        
        
        fTempX = ( fXIndex  + 0.5 ) / textureSize ;
        fTempY = ( fYIndex -scaleFactor + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
        
        // X Direction
        redXSum = redXSum + convolutionMatrix[0][1]*vTempColor.r;
        greenXSum = greenXSum + convolutionMatrix[0][1]*vTempColor.g;
        blueXSum = blueXSum + convolutionMatrix[0][1]*vTempColor.b;
        
        fTempX = ( fXIndex  + 0.5 ) / textureSize ;
        fTempY = ( fYIndex +scaleFactor + 0.5 ) / textureSize ;
        vTempColor = texture2D(sTexture, vec2(fTempX,fTempY));
        
        // X Direction
        
        redXSum = redXSum + convolutionMatrix[2][1]*vTempColor.r;
        greenXSum = greenXSum + convolutionMatrix[2][1]*vTempColor.g;
        blueXSum = blueXSum + convolutionMatrix[2][1]*vTempColor.b;
        
        
        
        float oneFloat = float(1.0);
        float zeroFloat = float(0.0);
        
        if(redXSum<zeroFloat){
        	redXSum = zeroFloat;
        }
        
        if(redXSum>oneFloat){
        	redXSum = oneFloat;
        }
        
        if(greenXSum<zeroFloat){
        	greenXSum = zeroFloat;
        }
        
        if(greenXSum>oneFloat){
        	greenXSum = oneFloat;
        }
        
        
        if(blueXSum<zeroFloat){
        	blueXSum = zeroFloat;
        }
        
        if(blueXSum>oneFloat){
        	blueXSum = oneFloat;
        }
        
        
        vColor.r = ((100.0-fade)*redXSum+fade*vColor.r)/100.0;
        vColor.g = ((100.0-fade)*greenXSum+fade*vColor.g)/100.0;
        vColor.b = ((100.0-fade)*blueXSum+fade*vColor.b)/100.0;
    }
    else
    {
    	vColor.r=1.0;
    	vColor.g = 1.0;
    	vColor.b = 1.0;
    }
    
    gl_FragColor = vColor;
}