precision highp float;
varying vec2 vTextureCoord;
uniform sampler2D sTexture;

uniform float scaleFactor;
uniform float textureSize;
uniform float textureWidth;
uniform float textureHeight;

uniform float fade;
uniform float contrast;
uniform float brightness;
uniform float lines;



vec3 RGBtoYUV(vec3 rgb){
	vec3 yuv = vec3(0.0,0.0,0.0);
	
	float red = rgb.r*255.0;
	float green = rgb.g*255.0;
	float blue = rgb.b*255.0;
	
	float y = 0.299*red + 0.587*green + 0.114*blue;
	float u = (blue-y)*0.565;
	float v = (red-y)*0.713;
	yuv.r = y;
	yuv.g = u;
	yuv.b = v;
	
	return yuv;
}


vec3 YUVtoRGB(vec3 yuv){
	vec3 rgb = vec3(0.0,0.0,0.0);
	rgb.r = yuv.x + 1.403*yuv.z;
	rgb.g = yuv.x - 0.344*yuv.y - 0.714*yuv.z;
	rgb.b = yuv.x + 1.770*yuv.y;
	
	return rgb;
}


float getGray(float x,float y){
    if(x<0.0){
        x = 0.0;
    }else if(x>=textureWidth){
        x = textureWidth - 1.0;
    }
    
    if(y<0.0){
        y = 0.0;
    }else if(y>=textureHeight){
        y = textureHeight - 1.0;
    }
    
    x/=textureSize;
    y/=textureSize;
    vec4 vTempColor = texture2D(sTexture, vec2(x,y));
    
    float r = vTempColor.r*255.0;
	float g = vTempColor.g*255.0;
	float b = vTempColor.b*255.0;

	float gray = (r+g+b)/3.0;
    return gray;
}

vec3 getYUV(float x,float y){
    if(x<0.0){
        x = 0.0;
    }else if(x>=textureWidth){
        x = textureWidth - 1.0;
    }
    
    if(y<0.0){
        y = 0.0;
    }else if(y>=textureHeight){
        y = textureHeight - 1.0;
    }
    
    x/=textureSize;
    y/=textureSize;
    vec4 vTempColor = texture2D(sTexture, vec2(x,y));
	vec3 yuv = RGBtoYUV(vTempColor.rgb);
    return yuv;
}


float saturate_cast(float v){
    if(v<0.0){
        v = 0.0;
    }else{
        if(v>255.0){
            v = 255.0;
        }
    }
    return v;
}




float setupLuma(float y,float howmuch){
	y = y/ howmuch;
	y = ceil(y);
    y *= howmuch;
	return y;
}

void main() {
	vec4 vColor = texture2D(sTexture, vTextureCoord);
	
	if(textureSize>0.0){
		float fXIndex = vTextureCoord.x*textureSize;
    	float fYIndex = vTextureCoord.y*textureSize;
    	
    	vec3 yuv = getYUV(fXIndex,fYIndex);
    	
    	
    	vec3 tyuv = getYUV(fXIndex,fYIndex+scaleFactor);
    	vec3 ttyuv = getYUV(fXIndex,fYIndex+2.0*scaleFactor);
    	vec3 byuv = getYUV(fXIndex,fYIndex-scaleFactor);
    	vec3 bbyuv = getYUV(fXIndex,fYIndex-2.0*scaleFactor);
    	
    	float y = yuv.x;
    	
    	float u = (tyuv.y+ttyuv.y+byuv.y+bbyuv.y+yuv.y*3.0)/7.0;
    	float v = (tyuv.z+ttyuv.z+byuv.z+bbyuv.z+yuv.z*3.0)/7.0;
    	
    	vec3 rgb = YUVtoRGB(vec3(y,u,v));
    	
    	
    	rgb.r = saturate_cast(rgb.r);
    	rgb.g = saturate_cast(rgb.g);
    	rgb.b = saturate_cast(rgb.b);
    	
    	rgb.r = setupLuma(rgb.r,32.0);
    	rgb.g = setupLuma(rgb.g,32.0);
    	rgb.b = setupLuma(rgb.b,32.0);
    	
    	rgb.r /= 255.0;
    	rgb.g /= 255.0;
    	rgb.b /= 255.0;
    	
    	
    	float tl = getGray(fXIndex-scaleFactor,fYIndex-scaleFactor);
    	float l =   getGray(fXIndex-scaleFactor,fYIndex);
    	float bl =  getGray(fXIndex-scaleFactor,fYIndex+scaleFactor);
    	float t =   getGray(fXIndex,fYIndex-scaleFactor);
    	float b =  getGray(fXIndex,fYIndex+scaleFactor);
    	float tr =  getGray(fXIndex+scaleFactor,fYIndex-scaleFactor);
    	float r =   getGray(fXIndex+scaleFactor,fYIndex);
    	float br =  getGray(fXIndex+scaleFactor,fYIndex+scaleFactor);
   
    	float dX = -tl - 2.0*l - bl + tr + 2.0*r + br;
    	float dY = -tl - 2.0*t - tr + bl + 2.0*b + br;
    	float grad = abs(dX) + abs(dY);
    	
    	
    	
    	float sobel = grad*2.0*lines/100.0;
    	sobel = saturate_cast(sobel);
    	sobel = 255.0-sobel;
    	sobel /= 255.0;
    	
    	
    	float red = rgb.r*sobel;
    	float green = rgb.g*sobel;
    	float blue = rgb.b*sobel;
    	
    	
    	red = red-0.5;
    	green = rgb.g-0.5;
    	blue = rgb.b-0.5;
    	
    	red = red*(contrast/50.0);
    	green = green*(contrast/50.0);
    	blue = blue*(contrast/50.0);
    	
    	red = red+0.5;
    	green = green+0.5;
    	blue = blue+0.5;
    	
    	red = red*(brightness/50.0);
    	green = green*(brightness/50.0);
    	blue = blue*(brightness/50.0);
    	
    	if(red<0.0){
    		red = 0.0;
    	}else if(red>1.0){
    		red = 1.0;
    	}
    	
    	if(green<0.0){
    		green = 0.0;
    	}else if(green>1.0){
    		green = 1.0;
    	}
    	
    	if(blue<0.0){
    		blue = 0.0;
    	}else if(blue>1.0){
    		blue = 1.0;
    	}
    	
    	vec4 effectColor = vec4(red,green,blue,vColor.a);
    	vec4 destColor = (fade*vColor+(100.0-fade)*effectColor)/100.0;
    	
    	if(destColor.r<0.0){
    		destColor.r = 0.0;
    	}else if(destColor.r>1.0){
    		destColor.r = 1.0;
    	}
    	
    	if(destColor.g<0.0){
    		destColor.g = 0.0;
    	}else if(destColor.g>1.0){
    		destColor.g = 1.0;
    	}
    	
    	if(destColor.b<0.0){
    		destColor.b = 0.0;
    	}else if(destColor.b>1.0){
    		destColor.b = 1.0;
    	}
    	
    	gl_FragColor = destColor;
	}else{
		gl_FragColor = vColor;
	}   
}